<?php

namespace FluentBooking\App\Services;

use FluentBooking\App\Models\Order;
use FluentBooking\App\Models\Transactions;
use FluentBooking\App\Services\Integrations\PaymentMethods\CurrenciesHelper;
use FluentBooking\Framework\Support\Arr;

class OrderHelper
{
    public $items = [];
    public $order;

    public function addItem($item)
    {
        $this->items[] = $item;
        return $this;
    }

    public function processDraftOrder($booking, $calendarSlot = [])
    {
        $paymentInfo = $calendarSlot->getMeta('payment_settings');

        $items = Arr::get($paymentInfo, 'items');
        $total = $this->getTotal($items);

        $currency = CurrenciesHelper::getGlobalCurrency();

        $data = [
            'status' => 'draft',
            'parent_id' => $booking->id,
            'order_number' => $booking->hash,
            'payment_method' => $booking->payment_method,
            'payment_method_title' => $booking->payment_method,
            'currency' => $currency,
            'total_amount' => $total,
            'uuid' => $booking->hash,
        ];

        $order = Order::query()->create($data);

        //create order Items
        $orderItem = [];
        foreach ($items as $item) {
            $itemPrice = intval($item['value'] * 100);
            $orderItem['booking_id'] = $booking->id;
            $orderItem['item_name'] = $item['title'];
            $orderItem['item_price'] = $itemPrice;
            $orderItem['quantity'] = 1;
            $orderItem['item_total'] = $itemPrice * 1;
            $orderItem['rate'] = 1;
            $orderItem['line_meta'] = wp_json_encode($item);
            $order->items()->create($orderItem);
        }

        $this->createDraftTransactions($order);
    }

    public function getTotal($items)
    {
        $total = 0;
        foreach ($items as $item) {
            $total += intval($item['value'] * 100);
        }
        return $total;
    }

    public function createDraftTransactions($order)
    {
        if (!$order) {
            return;
        }

        $data = [
            'object_id' => $order->id,
            'object_type' => 'order',
            'transaction_type' => 'online',
            'payment_method' => $order->payment_method,
            'status' => 'pending',
            'total' => $order->total_amount,
            'rate' => 1,
            'uuid' => $order->uuid,

        ];

        Transactions::create($data);
    }

    public function getOrderByHash($hash)
    {
        return Order::where('uuid', $hash)->first();
    }

}
